<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<#assign hasMQEntity=false>
<#list sys.getAllPSDataEntities() as dataEntity>
    <#if dataEntity.getAllPSDEDataSyncs?? && dataEntity.getAllPSDEDataSyncs()??>
        <#list dataEntity.getAllPSDEDataSyncs() as dataSync>
            <#assign hasMQEntity=true>
            <#break>
        </#list>
    </#if>
</#list>
<#if hasMQEntity>
    <#assign nameAddress="127.0.0.1:9876">
    <#assign instanceName="rmq-instance">
package ${pub.getPKGCodeName()}.core.util.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.rocketmq.client.consumer.DefaultMQPushConsumer;
import com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.alibaba.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.alibaba.rocketmq.common.message.MessageExt;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import java.util.List;

@Slf4j
@Configuration
public class RocketMQConfig {

    <#list sys.getAllPSDataEntities() as dataEntity>
        <#if dataEntity.getAllPSDEDataSyncs?? && dataEntity.getAllPSDEDataSyncs()??>
            <#list dataEntity.getAllPSDEDataSyncs() as dataSync>
                <#if dataSync.getOutPSSysDataSyncAgent?? && dataSync.getOutPSSysDataSyncAgent()??>
                    <#assign syncAgent=dataSync.getOutPSSysDataSyncAgent()>
                    <#assign producer=dataEntity.codeName+syncAgent.codeName+"producer">
                    <#if ((syncAgent.getAgentTag())!'')!=''>
                        <#assign nameAddress=syncAgent.getAgentTag()>
                    </#if>
                    <#if ((syncAgent.getAgentTag2())!'')!=''>
                        <#assign instanceName=syncAgent.getAgentTag2()>
                    </#if>
    @Bean("${producer}")
    public DefaultMQProducer ${srfmethodname(producer)}(){
        DefaultMQProducer producer = null;
        try{
            producer= new DefaultMQProducer();
            producer.setSendMsgTimeout(6000);
            producer.setNamesrvAddr("${nameAddress}");
            producer.setInstanceName("${instanceName}");
        }
        catch(Exception e){
            log.error("初始化消息发送对象异常!");
        }
        return producer;
    }
                </#if>
            </#list>
        </#if>
    </#list>

    <#list sys.getAllPSDataEntities() as dataEntity>
        <#if dataEntity.getAllPSDEDataSyncs?? && dataEntity.getAllPSDEDataSyncs()??>
            <#list dataEntity.getAllPSDEDataSyncs() as dataSync>
                <#if dataSync.getInPSSysDataSyncAgent?? && dataSync.getInPSSysDataSyncAgent()??>
                    <#assign syncAgent=dataSync.getInPSSysDataSyncAgent()>
                    <#assign consumer=dataEntity.codeName+syncAgent.codeName+"consumer">
                    <#assign entityName=dataEntity.getCodeName()>
                    <#if ((syncAgent.getAgentTag())!'')!=''>
                        <#assign nameAddress=syncAgent.getAgentTag()>
                    </#if>
                    <#if ((syncAgent.getAgentTag2())!'')!=''>
                        <#assign instanceName=syncAgent.getAgentTag2()>
                    </#if>
    @Autowired
    @Lazy
    ${pub.getPKGCodeName()}.core.${dataEntity.getPSSystemModule().getCodeName()?lower_case}.service.I${entityName}Service ${entityName}Service;

    @Bean("${consumer}")
    public DefaultMQPushConsumer ${srfmethodname(consumer)}(){
        DefaultMQPushConsumer consumer = null;
        try {
            consumer = new DefaultMQPushConsumer();
            consumer.setNamesrvAddr("${nameAddress}");
            consumer.setInstanceName("${instanceName}");
            consumer.subscribe("${dataSync.codeName}", "${dataSync.codeName}");
            consumer.registerMessageListener(new MessageListenerConcurrently() {
                public ConsumeConcurrentlyStatus consumeMessage(
                        List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                    for (MessageExt msg : msgs) {
                        <#if dataSync.getInTestPSDEAction()??>
                        <#assign inputAction=srfmethodname(dataSync.getInTestPSDEAction().codeName)>
                        ${pub.getPKGCodeName()}.core.${dataEntity.getPSSystemModule().getCodeName()?lower_case}.domain.${entityName} domain = JSON.parseObject(new String(msg.getBody()),${pub.getPKGCodeName()}.core.${dataEntity.getPSSystemModule().getCodeName()?lower_case}.domain.${entityName}.class);
                        ${entityName}Service.${inputAction}(domain);
                        <#else>
                        log.info("接收到[]消息，但未配置实体输入过滤行为，消息将被忽略。"+new String(msg.getBody()));
                        </#if>
                    }
                    return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                }
            });
            consumer.start();
        }catch (Exception e){
            log.error("初始化消息接收对象异常!");
        }
        return consumer;
    }
                </#if>
            </#list>
        </#if>
    </#list>
}
</#if>